  

---

### 1. Trust Assumptions in Modern Applications

- Many applications assume communication paths are trustworthy.
- Applications often lack built-in transmission security features.
- Adding cryptographic protection to all traffic can limit network visibility and advanced services.

---

### 2. Risks of Cleartext Communication

- Applications running in cleartext are vulnerable to low-level (infrastructure/data plane) attacks.
- Compromised data at lower OSI layers affects all higher layers.
- Example: If an attacker intercepts cleartext IP traffic, they can observe, hijack, or impersonate users.

---

### 3. OSI Layer Dependencies and Vulnerabilities

- **Layer Separation:**
    
    - Applications use transport-layer sockets; are unaware of lower-layer complexities.
    - Transport layer relies on the network layer for packet routing.
    - Network layer depends on the data link layer (MAC addresses) for frame delivery.
- **Man-in-the-Middle Threat:**
    
    - If Layer 2 is compromised, attackers can intercept traffic (e.g., between browser and server) unnoticed by higher layers.

---

### 4. Ethernet and Data Link Layer Security

- Ethernet, a common Layer 2 technology, has no built-in security.
- Technologies dependent on Ethernet (e.g., bridging, STP, ARP) also lack inherent security.
- Network devices now include features to secure Layer 2.

---

### 5. Common Layer 2 Attacks and Countermeasures

#### A. Attack Types and Threats

- **VLAN Hopping:** Gaining unauthorized access to VLANs.
- **STP Spoofing:** Manipulating Spanning Tree Protocol to redirect or black-hole traffic.
- **MAC Spoofing:** Using fake MAC addresses to steal identity/divert traffic.
- **CAM Table Flooding:** Overloading switch tables to cause network flooding.
- **DHCP Spoofing:** Malicious DHCP servers intercepting traffic.
- **DHCP Starvation:** Exhausting DHCP addresses to deny service.
- **ARP Spoofing:** Redirecting traffic within a subnet for interception.
- **Traffic Capture/Change:** Man-in-the-middle attacks to capture/modify traffic.
- **LAN Storm:** Excessive packet flooding degrading network performance.

#### B. Countermeasures

|Attack Type|Countermeasure(s)|
|---|---|
|VLAN Hopping|- Static access ports<br>- Disable Dynamic Trunking Protocol (DTP)<br>- Avoid trunk native VLAN on access ports|
|STP Spoofing|- BPDU guard<br>- Root guard|
|MAC Spoofing|- Port security|
|CAM Table Flooding|- Port security (MAC limit)|
|DHCP Spoofing|- DHCP snooping|
|DHCP Starvation|- Port security (MAC limit)<br>- DHCP snooping rate limit|
|ARP Spoofing|- ARP inspection|
|Traffic Capture/Changing|- MACsec|
|LAN Storm|- Storm control|

---

### 6. Detailed Attack Descriptions & Mitigations

- **VLAN Hopping:** Prevent by configuring static access ports, disabling DTP, and avoiding trunk native VLANs.
- **STP Spoofing:** Use BPDU guard and root guard features.
- **MAC Address Spoofing:** Implement port security to restrict MAC addresses per port.
- **CAM Table Flooding:** Limit allowed MAC addresses per access port.
- **DHCP Spoofing:** Deploy DHCP snooping to filter rogue DHCP servers.
- **DHCP Starvation:** Use port security and/or DHCP rate limiting.
- **ARP Spoofing:** Enable ARP inspection for legitimate ARP traffic.
- **Traffic Capture/Changing:** Use MACsec for cryptographic traffic protection.
- **LAN Storms:** Apply storm control to limit broadcast/multicast/unicast storm impact.

---

**Key Takeaway:**  
Securing Layer 2 with appropriate countermeasures is critical to prevent attackers from exploiting foundational network vulnerabilities, thereby protecting the entire OSI stack and maintaining application and data security.